
import { Header } from '@/components/layout/header';
import { Footer } from '@/components/layout/footer';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Building, Heart, ShieldCheck, Truck } from 'lucide-react';

export default function AboutPage() {
  return (
    <div className="flex min-h-screen flex-col">
      <Header />
      <main className="flex-1 bg-muted/40">
        <div className="container py-12 md:py-20">
          <Card className="max-w-4xl mx-auto">
            <CardHeader className="text-center p-8">
              <div className="mx-auto flex h-16 w-16 items-center justify-center rounded-full bg-primary/10 text-primary mb-4">
                 <Building className="h-8 w-8" />
              </div>
              <CardTitle className="text-4xl font-bold font-headline">Welcome to ChandraBrothers</CardTitle>
              <p className="text-muted-foreground text-lg mt-2">
                Your trusted online destination for safe, genuine, and affordable healthcare products.
              </p>
            </CardHeader>
            <CardContent className="px-8 pb-8 space-y-6 text-muted-foreground leading-relaxed">
              <p>
                Our mission is simple: to make quality medicines and wellness essentials accessible to everyone, anywhere, with convenience you can rely on. We work closely with licensed pharmacies, certified suppliers, and healthcare professionals to ensure that every product we offer meets the highest standards of safety and authenticity.
              </p>
              <p>
                From prescription medicines and over-the-counter drugs to vitamins, supplements, and personal care items, we are committed to delivering only verified and government-compliant products.
              </p>

              <div className="grid grid-cols-1 md:grid-cols-3 gap-6 pt-4">
                <div className="flex flex-col items-center text-center p-4 rounded-lg bg-background">
                  <ShieldCheck className="h-8 w-8 text-primary mb-2" />
                  <h3 className="font-semibold text-foreground">Quality & Safety</h3>
                  <p className="text-sm">We follow strict quality-check processes, secure packaging, and temperature-controlled storage.</p>
                </div>
                <div className="flex flex-col items-center text-center p-4 rounded-lg bg-background">
                  <Heart className="h-8 w-8 text-primary mb-2" />
                  <h3 className="font-semibold text-foreground">Customer-Centric</h3>
                  <p className="text-sm">We believe in transparent pricing, fast delivery, and exceptional customer support.</p>
                </div>
                 <div className="flex flex-col items-center text-center p-4 rounded-lg bg-background">
                  <Truck className="h-8 w-8 text-primary mb-2" />
                  <h3 className="font-semibold text-foreground">Reliable Delivery</h3>
                   <p className="text-sm">We are continually expanding to bring reliable medical supplies right to your doorstep.</p>
                </div>
              </div>

              <p className="pt-4">
                We believe in transparent pricing, fast delivery, and exceptional customer support. Our platform is designed to offer a seamless shopping experience, backed by encrypted payment systems and strict data-privacy practices to keep your personal information protected.
              </p>
              <p className="font-semibold text-center text-foreground text-base">
                Thank you for choosing ChandraBrothers — where trust, quality, and care meet technology to support your well-being.
              </p>
            </CardContent>
          </Card>
        </div>
      </main>
      <Footer />
    </div>
  );
}
