
'use client';

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
  CardFooter,
} from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';
import { Separator } from '@/components/ui/separator';
import {
  Phone,
  Mail,
  MapPin,
  Star,
  CheckCircle,
  Briefcase,
  Layers,
  Code,
  Database,
  Smartphone,
  Server,
  ShieldCheck,
  Linkedin,
  Github,
  Link as LinkIcon,
  MessageSquare,
  Video,
  FileText,
  KeyRound,
  Bell,
  BarChart,
  Webhook,
} from 'lucide-react';
import Link from 'next/link';

const skills = {
    "Backend": ["Node.js", "Express.js", "Firebase Functions", "MongoDB", "PostgreSQL"],
    "Frontend": ["Next.js", "React.js", "TailwindCSS", "TypeScript"],
    "CMS Platforms": ["WordPress", "WooCommerce", "Shopify"],
    "Mobile Apps": ["React Native", "Expo"],
    "DevOps": ["Docker", "CI/CD Pipelines"],
    "API Development": ["REST APIs", "GraphQL APIs"],
    "Security": ["Auth", "RBAC", "Encryption"],
}

const highlights = [
    "Custom E-commerce Systems",
    "Admin Dashboard Development",
    "Payment Gateway Integration",
    "Real-time Apps (Chats, Logs, Analytics)",
    "High-performance SEO-friendly sites",
    "Plugin & Theme Development"
]

const achievements = [
    "Completed 100+ website projects",
    "Built advanced e-commerce platforms",
    "Specialized in large-scale admin dashboards",
    "Rated 5★ for client satisfaction"
]

const services = [
    "Full website development",
    "Custom backend building",
    "Server setup / deployment",
    "Code optimization",
    "Security hardening",
    "Search engine optimization (SEO)",
    "Custom automation tools"
]


export default function DeveloperConnectPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
      <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Developer Connect</h1>
          <p className="text-muted-foreground">Contact, collaborate, and learn about the developer.</p>
        </div>
      </div>

        <div className="grid grid-cols-1 xl:grid-cols-3 gap-6">
           {/* Column 1: Profile & Contact */}
            <div className="xl:col-span-1 space-y-6">
                 {/* Developer Profile Card */}
                <Card>
                    <CardHeader className="text-center items-center">
                        <Avatar className="h-24 w-24 mb-2">
                            <AvatarImage src="/kaif-dev.jpeg" alt="Md Kaif Mondal" />
                            <AvatarFallback>MK</AvatarFallback>
                        </Avatar>
                        <CardTitle>Md Kaif Mondal</CardTitle>
                        <CardDescription>Full-Stack Web Developer</CardDescription>
                         <p className="text-sm text-amber-500 flex items-center gap-1 pt-1">
                            <Star className="w-4 h-4" /> “Building modern, secure, scalable applications for the future.”
                        </p>
                    </CardHeader>
                    <CardContent className="text-sm space-y-3">
                         <div className="flex items-start gap-3">
                            <Phone className="h-4 w-4 mt-0.5 text-muted-foreground flex-shrink-0" />
                            <span>7477861739</span>
                        </div>
                        <div className="flex items-start gap-3">
                            <Mail className="h-4 w-4 mt-0.5 text-muted-foreground flex-shrink-0" />
                            <a href="mailto:teamphoenix303@gmail.com" className="hover:underline">teamphoenix303@gmail.com</a>
                        </div>
                        <div className="flex items-start gap-3">
                            <MapPin className="h-4 w-4 mt-0.5 text-muted-foreground flex-shrink-0" />
                            <span>Nagar Natun Bazar, Murshidabad, West Bengal, India – 742159</span>
                        </div>
                    </CardContent>
                     <CardFooter className="flex-col gap-2">
                        <Button className="w-full" asChild>
                            <a href="https://wa.me/7477861739" target="_blank" rel="noopener noreferrer">
                                <MessageSquare className="mr-2" /> WhatsApp Connect
                            </a>
                        </Button>
                         <Button className="w-full" variant="outline" asChild>
                            <a href="mailto:teamphoenix303@gmail.com">
                                <Mail className="mr-2" /> Email Developer
                            </a>
                        </Button>
                         <Button className="w-full" variant="outline" asChild>
                            <a href="https://meet.google.com/new" target="_blank" rel="noopener noreferrer">
                                <Video className="mr-2" /> Book Google Meet
                            </a>
                        </Button>
                    </CardFooter>
                </Card>
                
                 {/* Developer Achievements */}
                <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2">
                            <Star className="text-amber-400" />
                            Achievements
                        </CardTitle>
                    </CardHeader>
                    <CardContent>
                        <ul className="space-y-2 text-sm text-muted-foreground">
                            {achievements.map((item, i) => (
                                <li key={i} className="flex items-center gap-2">
                                    <CheckCircle className="h-4 w-4 text-green-500" />
                                    <span>{item}</span>
                                </li>
                            ))}
                        </ul>
                    </CardContent>
                </Card>
            </div>
            
            {/* Column 2: Skills & Services */}
            <div className="xl:col-span-2 space-y-6">
                {/* Full Technology Stack Card */}
                <Card>
                    <CardHeader>
                        <CardTitle>Full Technology Stack Expertise</CardTitle>
                        <CardDescription className="text-amber-500 flex items-center gap-1 pt-1">
                            <Star className="w-4 h-4" /> “Crafting powerful digital experiences using modern technology.”
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <div className="space-y-4">
                            {Object.entries(skills).map(([category, skillList]) => (
                                <div key={category}>
                                    <h4 className="font-semibold mb-2">{category}</h4>
                                    <div className="flex flex-wrap gap-2">
                                        {skillList.map(skill => <Badge key={skill} variant="secondary">{skill}</Badge>)}
                                    </div>
                                </div>
                            ))}
                        </div>
                        <Separator className="my-6" />
                        <div>
                             <h4 className="font-semibold mb-3">Highlights</h4>
                             <ul className="space-y-2 text-sm text-muted-foreground columns-1 md:columns-2">
                                {highlights.map((item, i) => (
                                    <li key={i} className="flex items-center gap-2">
                                        <CheckCircle className="h-4 w-4 text-primary" />
                                        <span>{item}</span>
                                    </li>
                                ))}
                            </ul>
                        </div>
                    </CardContent>
                </Card>

                {/* Developer Services Card */}
                <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2">
                            <Briefcase />
                            Developer Services
                        </CardTitle>
                    </CardHeader>
                    <CardContent>
                         <ul className="space-y-2 text-sm text-muted-foreground columns-1 md:columns-2">
                            {services.map((item, i) => (
                                <li key={i} className="flex items-center gap-2">
                                    <Layers className="h-4 w-4 text-primary" />
                                    <span>{item}</span>
                                </li>
                            ))}
                        </ul>
                    </CardContent>
                </Card>

                 {/* Developer Tools Access */}
                <Card>
                    <CardHeader>
                        <CardTitle>Developer Tools Access</CardTitle>
                        <CardDescription>Quick links to technical sections of the admin panel.</CardDescription>
                    </CardHeader>
                     <CardContent className="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <Button variant="outline" asChild><Link href="/admin/security"><KeyRound className="mr-2"/> API Keys</Link></Button>
                        <Button variant="outline" asChild><Link href="/admin/dev/connect"><Webhook className="mr-2"/> Webhooks</Link></Button>
                        <Button variant="outline" asChild><Link href="/admin/security"><BarChart className="mr-2"/> Logs</Link></Button>
                        <Button variant="outline" asChild><Link href="#"><FileText className="mr-2"/> Docs</Link></Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </div>
  );
}
