
'use client';

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import { Bell, FileDown, Settings, Archive, AlertTriangle, Siren } from 'lucide-react';
import { Switch } from '@/components/ui/switch';
import { Label } from '@/components/ui/label';

const lowStockProducts = [
    { name: 'Paracetamol 500mg Tablets', stock: 8, threshold: 10, sku: 'PC500-100' },
    { name: 'Vitamin C Plus Zinc', stock: 15, threshold: 20, sku: 'VCZ-50' },
];

const outOfStockProducts = [
    { name: "Men's Revitalizing Face Wash", stock: 0, threshold: 10, sku: 'MRFW-01' },
];

const expiringSoonProducts = [
    { name: 'Prefilled Insulin Syringe', stock: 50, expiryDate: '2025-01-15', sku: 'INS-PFS-01' },
    { name: 'Gentle Baby Lotion', stock: 30, expiryDate: '2025-02-01', sku: 'GBL-200' },
];


export default function InventoryAlertsPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
      <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Inventory Alerts</h1>
          <p className="text-muted-foreground">Monitor and manage products that need attention.</p>
        </div>
         <Button variant="outline">
            <FileDown className="mr-2" />
            Export Report
        </Button>
      </div>

       <Card>
        <CardHeader>
          <CardTitle>Notification Settings</CardTitle>
          <CardDescription>Configure how you receive automated inventory alerts.</CardDescription>
        </CardHeader>
        <CardContent className="flex flex-col md:flex-row gap-6 items-start md:items-center justify-between p-6 rounded-lg bg-muted/50">
           <div className="space-y-1">
                <h3 className="font-medium">Automatic Email Notifications</h3>
                <p className="text-sm text-muted-foreground">Receive an email when stock levels are critical.</p>
            </div>
            <div className="flex items-center space-x-2">
                <Switch id="email-notifications" />
                <Label htmlFor="email-notifications">Enable</Label>
            </div>
        </CardContent>
      </Card>

      <Tabs defaultValue="low-stock">
        <TabsList className="grid w-full grid-cols-3">
          <TabsTrigger value="low-stock">
            <AlertTriangle className="mr-2" />
            Low Stock ({lowStockProducts.length})
          </TabsTrigger>
          <TabsTrigger value="out-of-stock">
             <Archive className="mr-2" />
            Out of Stock ({outOfStockProducts.length})
          </TabsTrigger>
          <TabsTrigger value="expiring-soon">
             <Siren className="mr-2" />
            Expiring Soon ({expiringSoonProducts.length})
          </TabsTrigger>
        </TabsList>
        <TabsContent value="low-stock">
          <Card>
            <CardHeader>
              <CardTitle>Low Stock Alerts</CardTitle>
              <CardDescription>Products that have fallen below their stock threshold.</CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                  <TableRow>
                    <TableHead>Product Name</TableHead>
                    <TableHead>SKU</TableHead>
                    <TableHead className="text-center">Remaining Stock</TableHead>
                    <TableHead className="text-center">Stock Threshold</TableHead>
                    <TableHead className="text-right">Actions</TableHead>
                  </TableRow>
                </TableHeader>
                <TableBody>
                  {lowStockProducts.map(product => (
                    <TableRow key={product.sku}>
                      <TableCell className="font-medium">{product.name}</TableCell>
                      <TableCell>{product.sku}</TableCell>
                      <TableCell className="text-center">
                        <Badge variant="destructive">{product.stock}</Badge>
                      </TableCell>
                       <TableCell className="text-center">{product.threshold}</TableCell>
                      <TableCell className="text-right">
                        <Button variant="outline" size="sm">Restock</Button>
                      </TableCell>
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </TabsContent>
         <TabsContent value="out-of-stock">
           <Card>
            <CardHeader>
              <CardTitle>Out of Stock Products</CardTitle>
              <CardDescription>These products are completely out of stock.</CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                  <TableRow>
                    <TableHead>Product Name</TableHead>
                    <TableHead>SKU</TableHead>
                    <TableHead className="text-right">Actions</TableHead>
                  </TableRow>
                </TableHeader>
                <TableBody>
                  {outOfStockProducts.map(product => (
                    <TableRow key={product.sku}>
                      <TableCell className="font-medium">{product.name}</TableCell>
                      <TableCell>{product.sku}</TableCell>
                      <TableCell className="text-right">
                        <Button variant="secondary" size="sm">Notify Me When Available</Button>
                      </TableCell>
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </TabsContent>
         <TabsContent value="expiring-soon">
           <Card>
            <CardHeader>
              <CardTitle>Expiring Soon</CardTitle>
              <CardDescription>Products that are nearing their expiration date.</CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                  <TableRow>
                    <TableHead>Product Name</TableHead>
                    <TableHead>SKU</TableHead>
                    <TableHead>Stock</TableHead>
                    <TableHead>Expiry Date</TableHead>
                    <TableHead className="text-right">Actions</TableHead>
                  </TableRow>
                </TableHeader>
                <TableBody>
                  {expiringSoonProducts.map(product => (
                    <TableRow key={product.sku}>
                      <TableCell className="font-medium">{product.name}</TableCell>
                      <TableCell>{product.sku}</TableCell>
                      <TableCell>{product.stock}</TableCell>
                      <TableCell>
                        <Badge variant="destructive">{new Date(product.expiryDate).toLocaleDateString()}</Badge>
                      </TableCell>
                      <TableCell className="text-right">
                        <Button variant="outline" size="sm">Create Discount</Button>
                      </TableCell>
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </TabsContent>
      </Tabs>
    </div>
  );
}
