'use client';

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Button } from '@/components/ui/button';
import { ShoppingCart, Search, FileDown } from 'lucide-react';
import { Input } from '@/components/ui/input';
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from '@/components/ui/dropdown-menu';

export default function AdminOrdersPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
       <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Order Management</h1>
          <p className="text-muted-foreground">View, track, and manage all customer orders.</p>
        </div>
        <div className="flex gap-2">
            <Button variant="outline">
                <FileDown className="mr-2" />
                Export All
            </Button>
        </div>
      </div>

       <Card>
        <CardHeader>
           <CardTitle>All Orders</CardTitle>
           <CardDescription>A list of all orders placed by customers.</CardDescription>
           <div className="flex flex-col md:flex-row justify-between gap-4 pt-4">
                <div className="relative flex-1">
                    <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground" />
                    <Input placeholder="Search by Order ID, customer, or status..." className="pl-10 text-base" />
                </div>
                 <div className="flex items-center gap-2">
                    <Button variant="outline">Pending</Button>
                    <Button variant="outline">Shipped</Button>
                    <Button variant="outline">Delivered</Button>
                    <Button variant="ghost">Cancelled</Button>
                </div>
           </div>
        </CardHeader>
        <CardContent>
          <Alert>
            <ShoppingCart className="h-4 w-4" />
            <AlertTitle>No Orders Found</AlertTitle>
            <AlertDescription>
              There are no orders to display at the moment.
            </AlertDescription>
          </Alert>
        </CardContent>
      </Card>
    </div>
  );
}
