'use client';

import {
  Card,
  CardHeader,
  CardTitle,
  CardContent,
  CardDescription,
  CardFooter,
} from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import {
  Download,
  TrendingUp,
  Users,
  Archive,
  Undo2,
  Map,
  FileText,
  FileSpreadsheet,
} from 'lucide-react';
import {
  BarChart,
  Bar,
  XAxis,
  YAxis,
  CartesianGrid,
  Tooltip,
  Legend,
  ResponsiveContainer,
  AreaChart,
  Area,
} from 'recharts';

const productPerformanceData = [
  { name: 'Product A', sales: 400 },
  { name: 'Product B', sales: 300 },
  { name: 'Product C', sales: 500 },
  { name: 'Product D', sales: 200 },
  { name: 'Product E', sales: 600 },
];

const userActivityData = [
  { date: '2024-01', newUsers: 50, activeUsers: 200 },
  { date: '2024-02', newUsers: 60, activeUsers: 220 },
  { date: '2024-03', newUsers: 80, activeUsers: 280 },
  { date: '2024-04', newUsers: 70, activeUsers: 300 },
  { date: '2024-05', newUsers: 90, activeUsers: 350 },
];

const reportCards = [
    { title: 'Total User Activity', value: '350 Active', icon: Users, description: '+15% from last month' },
    { title: 'Inventory Status', value: '8 Low Stock', icon: Archive, description: '2 items out of stock' },
    { title: 'Return/Refund Report', value: '5 New Requests', icon: Undo2, description: 'View and process returns' },
];

export default function AdminReportsPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
      <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Reports & Analytics</h1>
          <p className="text-muted-foreground">
            Detailed insights into your store's performance.
          </p>
        </div>
      </div>

      <Card>
        <CardHeader>
          <CardTitle>Sales Report</CardTitle>
          <CardDescription>
            A comprehensive overview of your sales performance over time.
          </CardDescription>
        </CardHeader>
        <CardContent>
          <p className="text-muted-foreground">
            This section will contain a detailed sales chart and data table.
          </p>
        </CardContent>
        <CardFooter className="flex gap-2">
          <Button variant="outline">
            <FileSpreadsheet className="mr-2" />
            Export as Excel
          </Button>
          <Button variant="outline">
            <FileText className="mr-2" />
            Export as PDF
          </Button>
        </CardFooter>
      </Card>

      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <Card>
          <CardHeader>
            <CardTitle>Product Performance</CardTitle>
            <CardDescription>Top-selling products by revenue.</CardDescription>
          </CardHeader>
          <CardContent>
            <ResponsiveContainer width="100%" height={300}>
              <BarChart data={productPerformanceData}>
                <CartesianGrid strokeDasharray="3 3" />
                <XAxis dataKey="name" fontSize={12} tickLine={false} axisLine={false} />
                <YAxis fontSize={12} tickLine={false} axisLine={false} />
                <Tooltip />
                <Bar dataKey="sales" fill="hsl(var(--primary))" radius={[4, 4, 0, 0]} />
              </BarChart>
            </ResponsiveContainer>
          </CardContent>
        </Card>
        <Card>
          <CardHeader>
            <CardTitle>User Activity</CardTitle>
            <CardDescription>New vs. active users over time.</CardDescription>
          </CardHeader>
          <CardContent>
             <ResponsiveContainer width="100%" height={300}>
              <AreaChart data={userActivityData}>
                <CartesianGrid strokeDasharray="3 3" />
                <XAxis dataKey="date" fontSize={12} />
                <YAxis fontSize={12} />
                <Tooltip />
                <Legend />
                <Area type="monotone" dataKey="newUsers" stackId="1" stroke="#8884d8" fill="#8884d8" />
                <Area type="monotone" dataKey="activeUsers" stackId="1" stroke="hsl(var(--primary))" fill="hsl(var(--primary))" />
              </AreaChart>
            </ResponsiveContainer>
          </CardContent>
        </Card>
      </div>

       <div className="grid gap-4 md:grid-cols-3">
        {reportCards.map((report) => (
            <Card key={report.title}>
                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                    <CardTitle className="text-sm font-medium">{report.title}</CardTitle>
                    <report.icon className="h-4 w-4 text-muted-foreground" />
                </CardHeader>
                <CardContent>
                    <div className="text-2xl font-bold">{report.value}</div>
                    <p className="text-xs text-muted-foreground">{report.description}</p>
                </CardContent>
            </Card>
        ))}
      </div>

      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Map />
            Location-wise Sales Heatmap
          </CardTitle>
          <CardDescription>
            Visualize sales distribution across different regions.
          </CardDescription>
        </CardHeader>
        <CardContent>
          <div className="h-64 bg-muted rounded-lg flex items-center justify-center">
            <p className="text-muted-foreground">Heatmap placeholder</p>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
