'use client';

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Undo2, Search } from 'lucide-react';
import { Input } from '@/components/ui/input';
import { Button } from '@/components/ui/button';

export default function AdminReturnsPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
       <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Return & Refund Requests</h1>
          <p className="text-muted-foreground">Manage and process all return and refund requests.</p>
        </div>
      </div>

       <Card>
        <CardHeader>
           <CardTitle>All Requests</CardTitle>
           <CardDescription>A list of all return and refund requests from customers.</CardDescription>
           <div className="flex flex-col md:flex-row justify-between gap-4 pt-4">
                <div className="relative flex-1">
                    <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground" />
                    <Input placeholder="Search by Order ID or customer..." className="pl-10 text-base" />
                </div>
                 <div className="flex items-center gap-2">
                    <Button variant="outline">Pending</Button>
                    <Button variant="outline">Approved</Button>
                    <Button variant="ghost">Rejected</Button>
                </div>
           </div>
        </CardHeader>
        <CardContent>
          <Alert>
            <Undo2 className="h-4 w-4" />
            <AlertTitle>No Return Requests Found</AlertTitle>
            <AlertDescription>
              There are no pending return or refund requests at the moment.
            </AlertDescription>
          </Alert>
        </CardContent>
      </Card>
    </div>
  );
}
