'use client';

import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Button } from '@/components/ui/button';
import { CreditCard, Search, FileDown } from 'lucide-react';
import { Input } from '@/components/ui/input';

export default function AdminTransactionsPage() {
  return (
    <div className="p-4 md:p-8 space-y-6">
       <div className="flex flex-col md:flex-row justify-between md:items-center gap-4">
        <div>
          <h1 className="text-3xl font-bold">Payments & Transactions</h1>
          <p className="text-muted-foreground">Monitor all payments and transactions processed through your store.</p>
        </div>
        <div className="flex gap-2">
            <Button variant="outline">
                <FileDown className="mr-2" />
                Export Report
            </Button>
        </div>
      </div>

       <Card>
        <CardHeader>
           <CardTitle>All Transactions</CardTitle>
           <CardDescription>A complete log of all financial transactions.</CardDescription>
           <div className="flex flex-col md:flex-row justify-between gap-4 pt-4">
                <div className="relative flex-1">
                    <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground" />
                    <Input placeholder="Search by Transaction ID, Order ID, or customer..." className="pl-10 text-base" />
                </div>
                 <div className="flex items-center gap-2">
                    <Button variant="outline">Success</Button>
                    <Button variant="outline">Failed</Button>
                    <Button variant="ghost">Refunded</Button>
                </div>
           </div>
        </CardHeader>
        <CardContent>
          <Alert>
            <CreditCard className="h-4 w-4" />
            <AlertTitle>No Transactions Found</AlertTitle>
            <AlertDescription>
              There are no transactions to display. This feature is pending implementation.
            </AlertDescription>
          </Alert>
        </CardContent>
      </Card>
    </div>
  );
}
