
'use client';

import { Header } from '@/components/layout/header';
import { Footer } from '@/components/layout/footer';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Mail, Phone, Clock, Bot, MapPin } from 'lucide-react';
import { LiveChat } from '@/components/live-chat';

export default function ContactPage() {
  return (
    <div className="flex min-h-screen flex-col">
      <Header />
      <main className="flex-1 bg-muted/40">
        <div className="container py-12 md:py-20">
          <Card className="max-w-4xl mx-auto">
            <CardHeader className="text-center p-8">
              <CardTitle className="text-4xl font-bold font-headline">Contact Us</CardTitle>
              <CardDescription className="text-lg mt-2">
                We’re here to help you stay healthy, informed, and supported every step of the way.
              </CardDescription>
            </CardHeader>
            <CardContent className="px-8 pb-8 grid grid-cols-1 md:grid-cols-2 gap-8">
              <div className="space-y-6">
                <h3 className="text-xl font-semibold text-primary">Customer Support</h3>
                <p className="text-muted-foreground">For general inquiries, product concerns, or help with placing an order, reach us at:</p>
                <ul className="space-y-3 text-sm">
                  <li className="flex items-center gap-3">
                    <Mail className="h-5 w-5 text-primary" />
                    <a href="mailto:chandrakrishna229@gmail.com" className="hover:underline">chandrakrishna229@gmail.com</a>
                  </li>
                  <li className="flex items-center gap-3">
                    <Phone className="h-5 w-5 text-primary" />
                    <span>+91 62942 06223</span>
                  </li>
                  <li className="flex items-center gap-3">
                    <Clock className="h-5 w-5 text-primary" />
                    <span>Mon – Sat, 9:00 AM to 7:00 PM</span>
                  </li>
                </ul>
              </div>
              <div className="space-y-6">
                <h3 className="text-xl font-semibold text-primary">Pharmacy Assistance</h3>
                <p className="text-muted-foreground">Need professional guidance? Our licensed pharmacy partners are available for advice.</p>
                <ul className="space-y-3 text-sm">
                  <li className="flex items-center gap-3">
                    <Mail className="h-5 w-5 text-primary" />
                     <a href="mailto:chandrakrishna229@gmail.com" className="hover:underline">chandrakrishna229@gmail.com</a>
                  </li>
                   <li className="flex items-center gap-3">
                    <Clock className="h-5 w-5 text-primary" />
                    <span>Mon – Fri, 10:00 AM to 6:00 PM</span>
                  </li>
                </ul>
              </div>
               <div className="space-y-6">
                <h3 className="text-xl font-semibold text-primary">Order & Delivery Help</h3>
                <p className="text-muted-foreground">Track your order, report delivery issues, or request assistance:</p>
                <ul className="space-y-3 text-sm">
                  <li className="flex items-center gap-3">
                    <Mail className="h-5 w-5 text-primary" />
                     <a href="mailto:chandrakrishna229@gmail.com" className="hover:underline">chandrakrishna229@gmail.com</a>
                  </li>
                </ul>
              </div>
                <div className="space-y-6">
                <h3 className="text-xl font-semibold text-primary">Business Inquiries</h3>
                <p className="text-muted-foreground">Want to collaborate or become a supplier?</p>
                <ul className="space-y-3 text-sm">
                  <li className="flex items-center gap-3">
                    <Mail className="h-5 w-5 text-primary" />
                     <a href="mailto:chandrakrishna229@gmail.com" className="hover:underline">chandrakrishna229@gmail.com</a>
                  </li>
                </ul>
              </div>
              <div className="md:col-span-2 mt-4">
                  <LiveChat />
              </div>
              <div className="md:col-span-2 mt-4 space-y-2">
                <h3 className="text-xl font-semibold text-primary flex items-center gap-2">
                    <MapPin className="h-5 w-5" />
                    Office Address
                </h3>
                <address className="text-muted-foreground not-italic">
                  Chandra Brother's Medical Store Nagar, Near B.D.O Office<br />
                  Khargram, Murshidabad, W.B<br />
                  742159, India
                </address>
              </div>
            </CardContent>
          </Card>
        </div>
      </main>
      <Footer />
    </div>
  );
}
