'use client';

import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';
import { RadioGroup, RadioGroupItem } from '@/components/ui/radio-group';
import { Label } from '@/components/ui/label';
import { Button } from '@/components/ui/button';
import { ScrollArea } from '@/components/ui/scroll-area';
import { useState } from 'react';
import { useToast } from '@/hooks/use-toast';

const languages = [
  { id: 'en', name: 'English' },
  { id: 'hi', name: 'हिंदी (Hindi)' },
  { id: 'ta', name: 'தமிழ் (Tamil)' },
  { id: 'te', name: 'తెలుగు (Telugu)' },
  { id: 'kn', name: 'ಕನ್ನಡ (Kannada)' },
  { id: 'bn', name: 'বাংলা (Bengali)' },
  { id: 'or', name: 'ଓଡ଼ିଆ (Odia)' },
  { id: 'mr', name: 'मराठी (Marathi)' },
  { id: 'gu', name: 'ગુજરાતી (Gujarati)' },
  { id: 'as', name: 'অসমীয়া (Assamese)' },
  { id: 'pa', name: 'ਪੰਜਾਬੀ (Punjabi)' },
  { id: 'ml', name: 'മലയാളം (Malayalam)' },
];

export default function LanguagePage() {
  const [selectedLanguage, setSelectedLanguage] = useState('en');
  const { toast } = useToast();

  const handleSaveChanges = () => {
    const language = languages.find(lang => lang.id === selectedLanguage);
    toast({
      title: 'Language Preference Saved',
      description: `Your preferred language is set to ${language?.name}. Full website translation is not yet implemented.`,
    });
  };

  return (
    <div className="p-4 md:p-8">
      <h1 className="text-2xl font-bold mb-6">Language Settings</h1>
      <Card className="max-w-md">
        <CardHeader>
          <CardTitle>Select Language</CardTitle>
        </CardHeader>
        <CardContent className="space-y-4">
          <ScrollArea className="h-72">
            <RadioGroup 
              defaultValue={selectedLanguage} 
              onValueChange={setSelectedLanguage}
              className="p-4"
            >
              {languages.map((language) => (
                <div key={language.id} className="flex items-center space-x-2 py-2">
                  <RadioGroupItem value={language.id} id={language.id} />
                  <Label htmlFor={language.id}>{language.name}</Label>
                </div>
              ))}
            </RadioGroup>
          </ScrollArea>
          <div className="border-t pt-4">
            <Button onClick={handleSaveChanges}>Save Changes</Button>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
