'use client';

import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';
import { OrderCard } from '@/components/order-card';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Truck } from 'lucide-react';
import { useUser, useFirestore, useCollection, useMemoFirebase } from '@/firebase';
import type { Order } from '@/lib/data';
import { collection } from 'firebase/firestore';
import { Skeleton } from '@/components/ui/skeleton';

export default function OrdersPage() {
  const { user } = useUser();
  const firestore = useFirestore();

  const ordersCollectionRef = useMemoFirebase(
    () => (user ? collection(firestore, 'users', user.uid, 'orders') : null),
    [firestore, user]
  );
  
  const { data: orders, isLoading, error } = useCollection<Order>(ordersCollectionRef);

  return (
    <div className="p-4 md:p-8">
      <h1 className="text-2xl font-bold mb-6">Track Orders</h1>
      {isLoading && (
        <div className="space-y-6">
            <Skeleton className="h-48 w-full" />
            <Skeleton className="h-48 w-full" />
        </div>
      )}

      {!isLoading && error && (
         <Card>
          <CardContent className="pt-6">
            <Alert variant="destructive">
              <Truck className="h-4 w-4" />
              <AlertTitle>Error Loading Orders</AlertTitle>
              <AlertDescription>
                Could not fetch your orders. Please try again later.
              </AlertDescription>
            </Alert>
          </CardContent>
        </Card>
      )}

      {!isLoading && !error && orders && orders.length > 0 && (
        <div className="space-y-6">
          {orders.map((order) => (
            <OrderCard key={order.id} order={order} />
          ))}
        </div>
      )}

      {!isLoading && !error && (!orders || orders.length === 0) && (
        <Card>
          <CardContent className="pt-6">
            <Alert>
              <Truck className="h-4 w-4" />
              <AlertTitle>No Orders Found</AlertTitle>
              <AlertDescription>
                You have not placed any orders yet. When you do, they will
                appear here.
              </AlertDescription>
            </Alert>
          </CardContent>
        </Card>
      )}
    </div>
  );
}
