
'use client';

import {
  Card,
  CardHeader,
  CardTitle,
  CardContent,
  CardDescription,
} from '@/components/ui/card';
import { useDoc, useFirestore, useMemoFirebase } from '@/firebase';
import { doc } from 'firebase/firestore';
import type { Settings } from '@/lib/data';
import { Skeleton } from '@/components/ui/skeleton';
import { Alert, AlertTitle, AlertDescription } from '@/components/ui/alert';
import ReactMarkdown from 'react-markdown';

function PrivacyPolicyContent() {
  const firestore = useFirestore();
  const settingsDocRef = useMemoFirebase(
    () => doc(firestore, 'settings', 'main'),
    [firestore]
  );
  const { data: settings, isLoading } = useDoc<Settings>(settingsDocRef);

  if (isLoading) {
    return (
      <div className="space-y-4">
        <Skeleton className="h-6 w-1/2" />
        <Skeleton className="h-4 w-full" />
        <Skeleton className="h-4 w-full" />
        <Skeleton className="h-4 w-3/4" />
      </div>
    );
  }

  const content =
    settings?.privacyPolicy ||
    'The privacy policy has not been configured yet.';

  return (
    <div className="prose prose-sm max-w-none text-muted-foreground">
      <ReactMarkdown>{content}</ReactMarkdown>
    </div>
  );
}

export default function PrivacyPage() {
  return (
    <div className="p-4 md:p-8">
      <h1 className="text-2xl font-bold mb-6">Privacy Policy</h1>
      <Card>
        <CardHeader>
          <CardTitle>Our Commitment to Your Privacy</CardTitle>
          <CardDescription>
            This policy outlines how we collect, use, and protect your
            information.
          </CardDescription>
        </CardHeader>
        <CardContent>
          <PrivacyPolicyContent />
        </CardContent>
      </Card>
    </div>
  );
}
