
'use client';

import {
  Card,
  CardHeader,
  CardTitle,
  CardContent,
  CardDescription,
} from '@/components/ui/card';
import { useDoc, useFirestore, useMemoFirebase } from '@/firebase';
import { doc } from 'firebase/firestore';
import type { Settings } from '@/lib/data';
import { Skeleton } from '@/components/ui/skeleton';
import ReactMarkdown from 'react-markdown';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';

function PolicyContent({ policyKey }: { policyKey: keyof Settings }) {
  const firestore = useFirestore();
  const settingsDocRef = useMemoFirebase(
    () => doc(firestore, 'settings', 'main'),
    [firestore]
  );
  const { data: settings, isLoading } = useDoc<Settings>(settingsDocRef);

  if (isLoading) {
    return (
      <div className="space-y-4">
        <Skeleton className="h-4 w-full" />
        <Skeleton className="h-4 w-full" />
        <Skeleton className="h-4 w-3/4" />
      </div>
    );
  }

  const content =
    (settings && settings[policyKey]) || 'This policy has not been configured yet.';

  return (
    <div className="prose prose-sm max-w-none text-muted-foreground">
      <ReactMarkdown>{content as string}</ReactMarkdown>
    </div>
  );
}

export default function TermsPage() {
  return (
    <div className="p-4 md:p-8">
      <h1 className="text-2xl font-bold mb-6">Terms & Policies</h1>
      <Card>
        <CardHeader>
          <CardTitle>ChandraBrothers Terms of Service & Policies</CardTitle>
          <CardDescription>
            Please read these terms carefully before using our service.
          </CardDescription>
        </CardHeader>
        <CardContent>
          <Tabs defaultValue="terms" className="w-full">
            <TabsList>
              <TabsTrigger value="terms">Terms & Conditions</TabsTrigger>
              <TabsTrigger value="returns">Return & Refund Policy</TabsTrigger>
            </TabsList>
            <TabsContent value="terms" className="mt-4">
              <PolicyContent policyKey="termsAndConditions" />
            </TabsContent>
            <TabsContent value="returns" className="mt-4">
              <PolicyContent policyKey="returnPolicy" />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
}
