'use client';

import { Card, CardContent } from '@/components/ui/card';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Ticket } from 'lucide-react';
import { SupportTicketTable } from '@/components/support-ticket-table';
import { useUser, useFirestore, useCollection, useMemoFirebase } from '@/firebase';
import { collection } from 'firebase/firestore';
import type { SupportTicket } from '@/lib/data';
import { Skeleton } from '@/components/ui/skeleton';

export default function SupportTicketsPage() {
    const { user } = useUser();
    const firestore = useFirestore();

    const ticketsCollectionRef = useMemoFirebase(
        () => (user ? collection(firestore, 'users', user.uid, 'tickets') : null),
        [firestore, user]
    );

    const { data: tickets, isLoading, error } = useCollection<SupportTicket>(ticketsCollectionRef);

  return (
    <div className="p-4 md:p-8">
      <div className="flex justify-between items-center mb-6">
        <h1 className="text-2xl font-bold">My Support Tickets</h1>
      </div>
      <Card>
        <CardContent className="pt-6">
          {isLoading && (
            <div className="space-y-2">
                <Skeleton className="h-12 w-full" />
                <Skeleton className="h-12 w-full" />
                <Skeleton className="h-12 w-full" />
            </div>
          )}
          {!isLoading && error && (
             <Alert variant="destructive">
              <Ticket className="h-4 w-4" />
              <AlertTitle>Error Loading Tickets</AlertTitle>
              <AlertDescription>
                Could not fetch support tickets. Please try again later.
              </AlertDescription>
            </Alert>
          )}
          {!isLoading && !error && tickets && tickets.length > 0 && (
            <SupportTicketTable tickets={tickets} />
          )}
           {!isLoading && !error && (!tickets || tickets.length === 0) && (
            <Alert>
              <Ticket className="h-4 w-4" />
              <AlertTitle>No Support Tickets Found</AlertTitle>
              <AlertDescription>
                You have not created any support tickets yet.
              </AlertDescription>
            </Alert>
          )}
        </CardContent>
      </Card>
    </div>
  );
}
