'use client';

import { Header } from '@/components/layout/header';
import { Footer } from '@/components/layout/footer';
import { HeroSection } from '@/components/hero-section';
import { CategorySlider } from '@/components/category-slider';
import { ProductSection } from '@/components/product-section';
import { useCollection, useFirestore, useMemoFirebase } from '@/firebase';
import { collection } from 'firebase/firestore';
import type { Product, CategoryData, HeroContent } from '@/lib/data';
import { useMemo } from 'react';
import { ServiceStrip } from '@/components/service-strip';

export default function Home() {
  const firestore = useFirestore();

  const productsCollectionRef = useMemoFirebase(
    () => collection(firestore, 'products'),
    [firestore]
  );

  const { data: products } = useCollection<Product>(productsCollectionRef);

  const { trendingProducts, bestSellers, newArrivals } = useMemo(() => {
    if (!products) {
      return {
        trendingProducts: [],
        bestSellers: [],
        newArrivals: [],
      };
    }
    const trending = products.filter(p => (p as any).trending).slice(0, 4);
    const best = [...products]
      .sort((a, b) => ((b as any).views || 0) - ((a as any).views || 0))
      .slice(0, 4);
    const latest = [...products]
      .sort(
        (a, b) =>
          ((b as any).createdAt?.seconds || 0) -
          ((a as any).createdAt?.seconds || 0)
      )
      .slice(0, 4);
    return {
      trendingProducts: trending,
      bestSellers: best,
      newArrivals: latest,
    };
  }, [products]);

  const sections = [
    { id: 'hero', component: <HeroSection /> },
    { id: 'categories', component: <CategorySlider /> },
    {
      id: 'trending',
      component: (
        <ProductSection title="Trending Products" products={trendingProducts} />
      ),
    },
    {
      id: 'bestsellers',
      component: (
        <ProductSection title="Best Sellers" products={bestSellers} />
      ),
    },
    {
      id: 'services',
      component: <ServiceStrip />,
    },
    {
      id: 'newarrivals',
      component: (
        <ProductSection title="New Arrivals" products={newArrivals} />
      ),
    },
  ];

  return (
    <div className="flex min-h-screen flex-col">
      <Header />
      <main className="flex-1">
        {sections.map((section) => (
          <div key={section.id}>{section.component}</div>
        ))}
      </main>
      <Footer />
    </div>
  );
}
