import Link from 'next/link';
import { Facebook, Instagram, Twitter, Send } from 'lucide-react';
import { Logo } from '@/components/logo';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';

const footerLinks = [
  {
    title: 'Company',
    links: [
      { label: 'About Us', href: '/about' },
      { label: 'Contact Us', href: '/contact' },
      { label: 'Privacy Policy', href: '/dashboard/privacy' },
      { label: 'Terms of Service', href: '/dashboard/terms' },
    ],
  },
  {
    title: 'Help',
    links: [
      { label: 'Help Center', href: '/dashboard/help' },
      { label: 'Track Order', href: '/dashboard/orders' },
      { label: 'Return Policy', href: '/dashboard/terms' },
    ],
  },
];

export function Footer() {
  return (
    <footer className="bg-muted/40 text-foreground">
      <div className="container py-12">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          <div className="space-y-4 md:col-span-2 lg:col-span-1">
            <Logo />
            <p className="text-sm text-muted-foreground">
              Your trusted partner in health and wellness. Delivering genuine medicines and healthcare products right to your doorstep.
            </p>
          </div>
          
          {footerLinks.map((section) => (
            <div key={section.title}>
              <h3 className="font-semibold text-foreground">{section.title}</h3>
              <ul className="mt-4 space-y-2 text-sm">
                {section.links.map((link) => (
                  <li key={link.label}>
                    <Link href={link.href} className="text-muted-foreground hover:text-primary transition-colors">
                      {link.label}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
          ))}

          <div>
            <h3 className="font-semibold text-foreground">Newsletter</h3>
            <p className="mt-4 text-sm text-muted-foreground">Subscribe for updates on new products and special offers.</p>
            <form className="mt-4 flex items-center gap-2">
              <Input type="email" placeholder="Your email" className="bg-background" />
              <Button type="submit" size="icon">
                <Send className="h-4 w-4" />
                <span className="sr-only">Subscribe</span>
              </Button>
            </form>
          </div>
        </div>
        
        <div className="mt-8 border-t pt-8 flex flex-col md:flex-row justify-between items-center">
          <p className="text-sm text-muted-foreground">&copy; {new Date().getFullYear()} ChandraBrothers. All rights reserved.</p>
          <div className="flex space-x-4 mt-4 md:mt-0">
            <Link href="#" className="text-muted-foreground hover:text-primary"><Facebook /></Link>
            <Link href="#" className="text-muted-foreground hover:text-primary"><Twitter /></Link>
            <Link href="#" className="text-muted-foreground hover:text-primary"><Instagram /></Link>
          </div>
        </div>
      </div>
    </footer>
  );
}
