'use client';

import type { Product } from '@/lib/data';
import { ProductCard } from './product-card';
import { Button } from './ui/button';
import Link from 'next/link';
import { Skeleton } from './ui/skeleton';

interface ProductSectionProps {
  title: string;
  products: Product[] | null;
}

export function ProductSection({ title, products }: ProductSectionProps) {
  if (!products) {
    return (
      <section
        id={title.toLowerCase().replace(/\s+/g, '-')}
        className="container py-12 md:py-16"
      >
        <div className="flex justify-between items-center mb-8">
          <h2 className="text-2xl md:text-3xl font-bold tracking-tight font-headline">
            {title}
          </h2>
          <Button variant="outline" asChild>
            <Link href="#">View All</Link>
          </Button>
        </div>
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6 justify-center">
          {[...Array(4)].map((_, i) => (
            <Skeleton key={i} className="h-[400px] w-full" />
          ))}
        </div>
      </section>
    );
  }

  return (
    <section
      id={title.toLowerCase().replace(/\s+/g, '-')}
      className="container py-12 md:py-16"
    >
      <div className="flex justify-between items-center mb-8">
        <h2 className="text-2xl md:text-3xl font-bold tracking-tight font-headline">
          {title}
        </h2>
        <Link href="#">
          <Button variant="outline">View All</Button>
        </Link>
      </div>
      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6 justify-center">
        {products.map((product) => (
          <ProductCard key={product.id} product={product} />
        ))}
      </div>
    </section>
  );
}
