import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Truck, Phone, ShieldCheck } from 'lucide-react';

const services = [
  {
    icon: Truck,
    title: 'Fast Delivery',
    description: 'Get your orders delivered to your doorstep in no time.',
  },
  {
    icon: Phone,
    title: '24/7 Customer Care',
    description: 'Our team is available round the clock to assist you.',
  },
  {
    icon: ShieldCheck,
    title: 'Genuine Medicines',
    description: '100% authentic and certified medical products.',
  },
];

export function ServiceStrip() {
  return (
    <section className="bg-muted">
      <div className="container py-12 md:py-16">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
          {services.map((service, index) => (
            <div key={index} className="flex flex-col items-center">
              <div className="flex h-16 w-16 items-center justify-center rounded-full bg-primary/10 text-primary mb-4">
                <service.icon className="h-8 w-8" />
              </div>
              <h3 className="text-xl font-bold font-headline">{service.title}</h3>
              <p className="text-muted-foreground mt-2">{service.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
