'use client';

import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';
import Link from 'next/link';
import { Eye } from 'lucide-react';
import type { SupportTicket, SupportTicketStatus } from '@/lib/data';

interface SupportTicketTableProps {
  tickets: SupportTicket[];
}

const statusVariant: { [key in SupportTicketStatus]: 'default' | 'secondary' | 'outline' | 'destructive' } = {
  'Open': 'default',
  'In Progress': 'secondary',
  'Resolved': 'default',
  'Closed': 'outline'
}


export function SupportTicketTable({ tickets }: SupportTicketTableProps) {
  return (
    <Table>
      <TableHeader>
        <TableRow>
          <TableHead>Ticket ID</TableHead>
          <TableHead>Category</TableHead>
          <TableHead>Order ID</TableHead>
          <TableHead>Status</TableHead>
          <TableHead>Last Updated</TableHead>
          <TableHead className="text-right">Actions</TableHead>
        </TableRow>
      </TableHeader>
      <TableBody>
        {tickets.map((ticket) => (
          <TableRow key={ticket.id}>
            <TableCell className="font-medium">{ticket.id}</TableCell>
            <TableCell>{ticket.issueCategory}</TableCell>
            <TableCell>{ticket.orderId || 'N/A'}</TableCell>
            <TableCell>
              <Badge variant={statusVariant[ticket.status] || 'default'}>{ticket.status}</Badge>
            </TableCell>
            <TableCell>
              {new Date(ticket.updatedAt.seconds * 1000).toLocaleDateString()}
            </TableCell>
            <TableCell className="text-right">
              <Button asChild variant="ghost" size="icon">
                <Link href={`/dashboard/tickets/${ticket.id}`}>
                  <Eye className="h-4 w-4" />
                  <span className="sr-only">View Details</span>
                </Link>
              </Button>
            </TableCell>
          </TableRow>
        ))}
      </TableBody>
    </Table>
  );
}
