
"use client"

import * as React from "react"

import {
  Reorder as ReorderPrimitive,
  useDragControls,
} from "framer-motion"

import { GripVertical } from "lucide-react"

import { cn } from "@/lib/utils"
import { Button } from "@/components/ui/button"

const Reorder = ReorderPrimitive

const ReorderItem = React.forwardRef<
  React.ElementRef<typeof ReorderPrimitive.Item>,
  React.ComponentPropsWithoutRef<typeof ReorderPrimitive.Item>
>(({ className, ...props }, ref) => (
  <ReorderPrimitive.Item ref={ref} className={cn("", className)} {...props} />
))
ReorderItem.displayName = "ReorderItem"

const ReorderTrigger = React.forwardRef<
  React.ElementRef<typeof Button>,
  Omit<React.ComponentPropsWithoutRef<typeof Button>, "onPointerDown">
>(({ className, ...props }, ref) => {
  const controls = useDragControls()

  return (
    <Button
      ref={ref}
      variant="ghost"
      size="icon"
      className={cn("h-7 w-7", className)}
      onPointerDown={(event) => {
        controls.start(event)
        event.preventDefault()
      }}
      {...props}
    />
  )
})
ReorderTrigger.displayName = "ReorderTrigger"

const ReorderHandle = React.forwardRef<
  React.ElementRef<typeof ReorderTrigger>,
  Omit<React.ComponentPropsWithoutRef<typeof ReorderTrigger>, "children">
>((props, ref) => (
  <ReorderTrigger ref={ref} {...props}>
    <GripVertical className="h-4 w-4" />
  </ReorderTrigger>
))
ReorderHandle.displayName = "ReorderHandle"

export { Reorder, ReorderItem, ReorderTrigger, ReorderHandle }
