'use client';

import {
  collection,
  addDoc,
  Firestore,
  serverTimestamp,
} from 'firebase/firestore';
import { errorEmitter } from '@/firebase/error-emitter';
import {
  FirestorePermissionError,
  type SecurityRuleContext,
} from '@/firebase/errors';

export function addProduct(db: Firestore, data: any) {
  const productData = {
    ...data,
    createdAt: serverTimestamp(),
    updatedAt: serverTimestamp(),
    images: data.imageUrl ? [data.imageUrl] : [],
    trending: data.isTrending || false,
    views: 0,
    originalPrice: data.mrp,
    title: data.name,
  };
  delete productData.isTrending;
  delete productData.isBestSeller;
  delete productData.isFeatured;
  delete productData.mrp;
  delete productData.name;
  delete productData.imageUrl;

  const collectionRef = collection(db, 'products');

  // The Promise is returned so the UI can know when the operation is settled.
  return addDoc(collectionRef, productData).catch((serverError) => {
    // The error is emitted for global handling by the FirebaseErrorListener.
    const permissionError = new FirestorePermissionError({
      path: collectionRef.path,
      operation: 'create',
      requestResourceData: productData,
    } satisfies SecurityRuleContext);
    errorEmitter.emit('permission-error', permissionError);
    
    // We re-throw the original error so the calling component's .catch() block is triggered.
    throw serverError;
  });
}
