'use client';

import { doc, setDoc, Firestore } from 'firebase/firestore';
import { errorEmitter } from '@/firebase/error-emitter';
import {
  FirestorePermissionError,
  type SecurityRuleContext,
} from '@/firebase/errors';

export function setUserData(db: Firestore, userId: string, data: any) {
  const docRef = doc(db, 'users', userId);

  // NO await here. Chain the .catch() block.
  setDoc(docRef, data, { merge: true }).catch(async (serverError) => {
    const permissionError = new FirestorePermissionError({
      path: docRef.path,
      operation: 'write',
      requestResourceData: data,
    } satisfies SecurityRuleContext);

    errorEmitter.emit('permission-error', permissionError);
  });
}
