
'use client';

import { doc, setDoc, Firestore } from 'firebase/firestore';
import { errorEmitter } from '@/firebase/error-emitter';
import {
  FirestorePermissionError,
  type SecurityRuleContext,
} from '@/firebase/errors';
import type { Settings } from '@/lib/data';

/**
 * Updates the global website settings.
 * This function uses a known document ID ('main') to update the single settings document.
 */
export function updateSettings(
  db: Firestore,
  data: Partial<Omit<Settings, 'id'>>
) {
  const docRef = doc(db, 'settings', 'main');
  
  return setDoc(docRef, data, { merge: true }).catch((serverError) => {
    const permissionError = new FirestorePermissionError({
      path: docRef.path,
      operation: 'update',
      requestResourceData: data,
    } satisfies SecurityRuleContext);
    errorEmitter.emit('permission-error', permissionError);
    // Re-throw the error so the caller's .catch() can handle UI updates
    throw serverError;
  });
}
