
'use server';

import { intelligentProductSearch } from '@/ai/flows/intelligent-product-search';
import { liveChat } from '@/ai/flows/live-chat';

export async function handleIntelligentSearch(query: string): Promise<{ suggestions?: string[], error?: string }> {
  if (!query) {
    return { suggestions: [] };
  }

  try {
    const result = await intelligentProductSearch({ query });
    return { suggestions: result.suggestedProducts };
  } catch (error) {
    console.error('Error in intelligent search:', error);
    return { error: 'Failed to fetch suggestions. Please try again.' };
  }
}

export async function handleLiveChat(query: string, category: string): Promise<string> {
    if (!query || !category) {
        return "I'm sorry, I need both a question and a category to help you.";
    }

    try {
        const result = await liveChat({ query, category });
        return result.response;
    } catch (error) {
        console.error('Error in live chat flow:', error);
        return 'I seem to be having trouble connecting. Please try again in a moment.';
    }
}
